#' Clinical and MRI data sets
#' 
#' This package provides several data sets with clinical and MRI data:
#' 
#' * \code{clinical}: a data frame with clinical data for all subjects
#' * \code{clinical_train}: a data frame with clinical data for training subjects
#' * \code{clinical_test}: a data frame with clinical data for testing subjects
#' * \code{mri}: a list with MRI data for all subjects
#' * \code{mri_train}: a list with MRI data for training subjects
#' * \code{mri_test}: a list with MRI data for testing subjects
#'
#' @docType data
#' @name clinical
#' @format A data frame with clinical data for all subjects
#'
#' @docType data
#' @name clinical_train
#' @format A data frame with clinical data for training subjects
#'
#' @docType data
#' @name clinical_test
#' @format A data frame with clinical data for testing subjects
#'
#' @docType data
#' @name mri
#' @format A list with MRI data for all subjects
#'
#' @docType data
#' @name mri_train
#' @format A list with MRI data for training subjects
#'
#' @docType data
#' @name mri_test
#' @format A list with MRI data for testing subjects