\name{mripredict_cv}
\alias{mripredict_cv}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
%%  ~~function to do ... ~~
MRIPredict Crossvalidation
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
Function to perform a crossvalidation.
}
\usage{
mripredict_cv(mp, space = "MNI", save_name = "results_cv", 
preloaded_covB_path = NULL, preloaded_covB_fu_path = NULL, folds_file = NULL, 
n_cores = 1, use_significant_voxels = FALSE, use_ensemble_voxels = FALSE, 
use_ensemble_subjects = FALSE, n_folds = 10, ide_shiny = FALSE, 
standardize_images = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{mp}{
%%     ~~Describe \code{mp} here~~
An MRIPredict object, as created by the function mripredict.
}
  \item{space}{
%%     ~~Describe \code{space} here~~
Images should be MNI aligned. This field can be "MNI" or "NO_CHECK" if images 
are not in MNI but the user decides to not check space alignment.
}
  \item{save_name}{
%%     ~~Describe \code{save_name} here~~
A string with the name to be used for saving the results
}
  \item{folds_file}{
%%     ~~Describe \code{folds_file} here~~
A folds file as generated by previous executions of mripredict_cv. It is useful 
for replication.
}
  \item{n_cores}{
%%     ~~Describe \code{n_cores} here~~
Number of cores to be used by the software. Take into account that more cores 
means more RAM usage, so try to not use too many cores.
}
  \item{use_significant_voxels}{
%%     ~~Describe \code{use_significant_voxels} here~~
A boolean indicating whether only significant voxels should be used.
}
  \item{use_ensemble_voxels}{
%%     ~~Describe \code{use_ensemble_voxels} here~~
A boolean indicating whether an ensemble approach should be used. If 'true' the 
software will split the brain into 18 cuts and merge the linear predictors 
for each model into a single result in the end.
}
  \item{use_ensemble_subjects}{
%%     ~~Describe \code{use_ensemble_subjects} here~~
A boolean indicating whether an ensemble approach should be used. If 'true' the 
software will sample 18 times the order of subjects.
}
  \item{n_folds}{
%%     ~~Describe \code{n_folds} here~~
A numeric value >3 to indicate how many folds should be used. 
}
  \item{standardize_images}{
%%     ~~Describe \code{standardize_images} here~~
A boolean indicating whether images should be standardized between them.
}
  \item{preloaded_covB_path}{
A list of modulated images with the effect of covariates already removed. Not 
recommended, empty by default. 
}
\item{preloaded_covB_fu_path}{
A list of fully modulated images with the effect of covariates already removed. 
Not recommended, empty by default. 
}
\item{ide_shiny}{
Parameter to indicate whether the function is being called from a shiny 
interface. False by default.
}
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
An MRIPredict object that can be accessed like a common list.
}
\references{
%% ~put references to the literature/web site here ~
Solanes, A. (2022), et al. Combining MRI and clinical data to detect high 
relapse risk after the first episode of psychosis. Schizophrenia (Heidelb). 
2022 Nov 17;8(1):100. doi: 10.1038/s41537-022-00309-w.
}
\author{
Joaquim Radua and Aleix Solanes
Maintainer: Aleix Solanes <email: solanes@recerca.clinic.cat>
}

\examples{
\dontrun{
x = list(mri$unmodulated, mri$modulated)

# create an mripredict parameters object. Predict the sex covarying by age 
# centered and considering the score1 predictor variable, along with mri data.
mp <- mripredict(mri_data=x, data_table_file = clinical, 
                 response_var="female", covariates=c("cent_age"), 
                 predictor=c("score1"), 
                 response_family="binomial",modulation="un")
                 
# perform a 10-fold cross-validation
mp <- mripredict_cv(mp, space = "NO_CHECK", 
                    save_name = "testing", use_ensemble_voxels = TRUE,
                    folds_file = NULL, 
                    n_cores = 1, 
                    n_folds = 10)
                    
                    
# perform a survival cox proportional hazards analysis
mp <- mripredict(mri_data = mri_train, clinical_data = clinical,
                 response_var=c("time","status"), covariates=c("cent_age"), 
                 predictor=c("score1"),
                 response_family="cox", modulation="un")

mp <- mripredict_cv(mp, space = "NO_CHECK", 
                    save_name = "testing", 
                    folds_file = NULL, 
                    n_cores = 1, 
                    n_folds = 5)
## End(**Not run**)
}
}
\keyword{ models }
\keyword{ crossvalidation }
\keyword{ regression }
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
