\name{mripredict_fit}
\alias{mripredict_fit}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
%%  ~~function to do ... ~~
MRIPredict fit
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
Train a model to be applied later on new data.
}
\usage{
mripredict_fit(mp, space = "MNI", save_name = "results_cv", 
preloaded_covB_path = NULL, preloaded_covB_fu_path = NULL, folds_file = "", 
n_cores = 1, use_significant_voxels = FALSE, use_ensemble_learning = FALSE, 
use_ensemble_voxels = FALSE, use_ensemble_subjects = FALSE, ide_shiny = FALSE, 
standardize_images = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{mp}{
An MRIPredict object, as created by the function mripredict.
}
  \item{space}{
%%     ~~Describe \code{space} here~~
A string that can be 'MNI' or 'NO_CHECK'. Images are supposed to be aligned to 
MNI, this can be skipped by setting this to 'NO_CHECK'. 
'NO_CHECK' should be used only if the user is sure that all images are correctly 
aligned to the same space. Also take into account, 
that the software will output MNI coordinates for the MRI images, so if images 
are not MNI-aligned these values will not be reliable.
}
  \item{save_name}{
%%     ~~Describe \code{save_name} here~~
A string with the name to be used for saving the results
}
  \item{folds_file}{
%%     ~~Describe \code{folds_file} here~~
A folds file as generated by previous executions of mripredict_cv. It is useful 
for replication.
}
  \item{n_cores}{
%%     ~~Describe \code{n_cores} here~~
Number of cores to be used by the software. Take into account that more cores 
means more RAM, so take care.
}
  \item{use_significant_voxels}{
%%     ~~Describe \code{use_significant_voxels} here~~
A boolean indicating whether only significant voxels should be used.
}
  \item{use_ensemble_learning}{
%%     ~~Describe \code{use_ensemble_learning} here~~
A boolean indicating whether to use ensemble learning or not.
}
  \item{use_ensemble_voxels}{
%%     ~~Describe \code{use_ensemble_voxels} here~~
A boolean indicating whether an ensemble approach should be used. If 'true' the 
software will split the brain into 18 cuts and merge the linear predictors 
for each model into a single result in the end.
}
  \item{use_ensemble_subjects}{
%%     ~~Describe \code{use_ensemble_subjects} here~~
A boolean indicating whether an ensemble approach should be used. If 'true' the 
software will sample 18 times the order of subjects.
}
  \item{standardize_images}{
%%     ~~Describe \code{standardize_images} here~~
A boolean indicating whether images should be standardized between them.
}
  \item{preloaded_covB_path}{
A list of modulated images with the effect of covariates already removed. Not 
recommended, empty by default. 
}
\item{preloaded_covB_fu_path}{
A list of fully modulated images with the effect of covariates already removed. 
Not recommended, empty by default. 
}
\item{ide_shiny}{
Parameter to indicate whether the function is being called from a shiny 
interface. False by default.
}
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
An MRIPredict object that can be accessed like a common list. Can be passed as 
a parameter to 'mripredict_predict' function.
}
\references{
%% ~put references to the literature/web site here ~
Solanes, A. (2022), et al. Combining MRI and clinical data to detect high 
relapse risk after the first episode of psychosis. Schizophrenia (Heidelb). 
2022 Nov 17;8(1):100. doi: 10.1038/s41537-022-00309-w.
}
\author{
Joaquim Radua and Aleix Solanes
Maintainer: Aleix Solanes <email: solanes@recerca.clinic.cat>
}

\examples{
\dontrun{

# create an object of class mripredict
  mp <- mripredict(mri_data = mri_train, data_table_file = clinical_train,
                 response_var="female", covariates=c("cent_age"), 
                 predictor=c("score1"),
                 response_family="binomial", modulation="fu")
# train a model trying to predict sex, covarying per centered age, and score1 as 
a predictor variable
  mp <- mripredict_fit(mp, space = "MNI", save_name = "model_fit")

}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
